function [verts] = corr_rnd_verts(num,vsize,thresh,forf)
%This function will generate xyz vertices of varying clumpiness
%Synatax:   [verts] = corr_rnd_verts(50000,[2000 1500 100],0.1,1000,1)
%Input:     num = the number of vertices you want to generate
%           vsize = the size of volume [x y z].  The numbers being the max.
%           thresh = the distance threshold, which controls the clumpiness
%                   or correlation.
%           forf = "friend or foe" whether the thresh is used to include or
%                   exclude.  1 = include. 0 = exclude
%Output:    verts = the generated vertices.

smod = 500;  %we will need to generate more to get enough verts

matlabpool

verts = [];
h = waitbar(0,'Generating Random Vertices: 0');    %initialize progress bar.       
%now add all the other vertices
while 1     %continue until we hit the number desired
    ini = size(verts,1)+1;   %we want to start searching from the end of the last search session, no redundencies
    vert_tmp = rand(num-size(verts,1)+smod,3).*repmat(vsize,num-size(verts,1)+smod,1);  %generate the initial seeds
    %vert_tmp(vert_tmp==0) = 1;  %no zeros
    verts = vertcat(verts,vert_tmp);   %add new verts
    out_idx = zeros(size(verts,1),1);    %initiate
    %lets check with criteria first
    parfor j = ini:size(verts,1)  %step through
        [neighbors,tmp,idx] = find_neighbors2(verts(j,:),verts,thresh*2);
        neighbors(idx==j,:) = [];   %remove the self vertex
        dist_tmp = dddist(repmat(verts(j,:),size(neighbors,1),1),neighbors);  %calculate the distances to rest of dataset
        if forf     %include or exclude
            if min(dist_tmp)>thresh     %does not meet criteria for include
                out_idx(j) = j;  %remove
            end
        else    %exclude
            if min(dist_tmp)<thresh     %does not meet criteria for exclude
                out_idx(j) = j;  %remove
            end
        end
    end
    out_idx(out_idx==0,:) = []; %formalize the final out index
    verts(out_idx,:) = [];   %remove the uninteresting
    waitbar(size(verts,1)/num,h,['Generating Random Vertices: ',num2str(size(verts,1))]);   %update progress
    if size(verts,1)>num    %we got enough
        break
    end
end
verts = verts(1:num,:);   %output only the number desired
close(h)
matlabpool close